import CryptoJS from 'crypto-js';

const SECRET_KEY = 'your-secret-key-2024'; // 在实际生产环境中应该使用环境变量

export const authUtils = {
  // 加密数据
  encrypt(data) {
    return CryptoJS.AES.encrypt(JSON.stringify(data), SECRET_KEY).toString();
  },

  // 解密数据
  decrypt(encryptedData) {
    try {
      const bytes = CryptoJS.AES.decrypt(encryptedData, SECRET_KEY);
      return JSON.parse(bytes.toString(CryptoJS.enc.Utf8));
    } catch (error) {
      console.error('Decryption failed:', error);
      return null;
    }
  },

  // 检查token是否接近过期
  isTokenNearExpiry(token) {
    try {
      const tokenData = JSON.parse(atob(token.split('.')[1]));
      const expiryTime = tokenData.exp * 1000; // 转换为毫秒
      const currentTime = Date.now();
      // 如果token将在15分钟内过期，返回true
      return (expiryTime - currentTime) < 15 * 60 * 1000;
    } catch (error) {
      console.error('Token expiry check failed:', error);
      return true;
    }
  },

  // 广播认证状态变化
  broadcastAuthChange(type, data = null) {
    window.localStorage.setItem('auth_sync', JSON.stringify({
      type,
      timestamp: Date.now(),
      data
    }));
  }
};
